import React, { useState } from 'react';

function RegistrationForm() {
  const [name, setName] = useState('');
  const [email, setEmail] = useState('');
  const [password, setPassword] = useState('');
  const [role, setRole] = useState('client'); // Default role
  const [error, setError] = useState('');

  const handleSubmit = async (e) => {
    e.preventDefault();
    try {
      const response = await fetch('/register', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ name, email, password, role })
      });

      if (response.ok) {
        // Registration successful, redirect to login
      } else {
        const errorData = await response.json();
        setError(errorData.error); // Assuming the backend sends an error message
      }
    } catch (error) {
      console.error('Registration error:', error);
      setError('An error occurred during registration.');
    }
  };

  return (
    <form onSubmit={handleSubmit} className="registration-form">
      {/* Input fields for name, email, password, role */}
      {error && <p className="error-message">{error}</p>}
      <button type="submit">Register</button>
    </form>
  );
}

export default RegistrationForm;